$input a_position, a_normal, a_tangent, a_texcoord0
$output v_normal, v_tangent, v_bitangent, v_view, v_texcoord0

/*
 * Copyright 2016 Jean-François Verdon. All rights reserved.
 * License: http://www.opensource.org/licenses/BSD-2-Clause
 */

#include "common.sh"

// TODO detect this shader permutation in cpp
#define MESH_HAS_PACKED_NORMALS

void main()
{
  // Vertex position
  vec3 worldPosition = mul(u_model[0], vec4(a_position, 1.0)).xyz;
  gl_Position = mul(u_viewProj, vec4(worldPosition, 1.0));

  // Normal / tangent
  vec4 normal = a_normal;
  vec4 tangent = a_tangent;

  // While converting meshes using geometryc, we can pack normals inside int values (--packnormal 1).
  // If this option is used, we need to unpack them before any transformation.
  // Tangents are packed the same way normals are.
  #ifdef MESH_HAS_PACKED_NORMALS
    normal = normal * 2.0 - 1.0;
    tangent = tangent * 2.0 - 1.0;
  #endif

  // Bitangent
  v_normal    = normalize(mul(u_model[0], vec4(normal.xyz, 0.0)).xyz);
  v_tangent   = normalize(mul(u_model[0], vec4(tangent.xyz, 0.0)).xyz);
  v_bitangent = normalize(mul(u_model[0], vec4(cross(normal.xyz, tangent.xyz) * tangent.w, 0.0)).xyz);

  vec3 worldEyePosition = mul(vec4(0.0, 0.0, 0.0, 1.0), u_view).xyz;
  v_view = normalize(worldPosition - worldEyePosition);

  // UVs
  v_texcoord0 = a_texcoord0;
}
